---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：1-Health Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ権限要件**：セキュリティプラグインの権限名が推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestHealthAction.java` 行54-134
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` 行59-110
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行2
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestTable.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cat/health | E-01 行58 | ○ |
| C-02 | RestHealthAction は AbstractCatAction を継承 | E-01 行54 | ○ |
| C-03 | allowSystemIndexAccessByDefault が true | E-01 行67-69 | ○ |
| C-04 | ClusterHealthRequest を使用してデータ取得 | E-01 行78 | ○ |
| C-05 | startHeadersWithTimestamp でタイムスタンプ付与 | E-01 行91 | ○ |
| C-06 | cluster カラムの定義 | E-01 行92 | ○ |
| C-07 | status カラムは toLowerCase で小文字化 | E-01 行119 | ○ |
| C-08 | node.total カラムの定義 | E-01 行94 | ○ |
| C-09 | node.data カラムの定義 | E-01 行95 | ○ |
| C-10 | discovered_cluster_manager カラムの定義 | E-01 行98-101 | ○ |
| C-11 | shards カラムの定義とエイリアス | E-01 行102 | ○ |
| C-12 | max_task_wait_time は 0ms で「-」表示 | E-01 行129 | ○ |
| C-13 | active_shards_percent は %1.1f%% フォーマット | E-01 行130 | ○ |
| C-14 | discovered_master エイリアスの後方互換性 | E-01 行97,100 | ○ |
| C-15 | 常に1行出力 | E-01 行117,131 | ○ |
| C-16 | helpパラメータでヘルプ表示 | E-02 行69 | ○ |
| C-17 | 帳票一覧での定義内容 | E-03 | ○ |
| C-18 | RestTable.buildResponseでレスポンス生成 | E-01 行83 | ○ |
| C-19 | レスポンスパラメータ（format, h, v, ts, s等） | E-02 行93-95 | ○ |
| C-20 | セキュリティプラグインで cluster:monitor/health 権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティプラグインの権限設定はRestHealthAction.javaには記載がなく、セキュリティプラグインのコードに基づく推定値
  - 候補：security plugin の設定ファイル / OpenSearch公式ドキュメント / セキュリティプラグインのソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの構造と処理フローは完全にコードから読み取れる
- 1: 中リスク - セキュリティ権限名の正確性

## 6) レビュアーチェックリスト（最小）
- [ ] テーブルカラム定義（13カラム）がソースコードのaddCellと一致しているか
- [ ] エイリアス名がソースコードと完全一致しているか
- [ ] セキュリティ権限の記述が運用環境の設定と整合しているか
